/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;

import jp.mosp.kintai.dto.MYukyuDto;

public class PaidHolidayCardVo extends MosPVo {

	private static final long serialVersionUID = 4422751719733412912L;

	// URL
	private static final String RETURN_URL = "/jsp/kintai/paidHolidayCard.jsp";
	private static final String EXTRA_JS   = "/pub/kintai/js/paidHolidayCard.js";
	private static final String EXTRA_CSS  = "/pub/kintai/css/paidHolidayCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_PAID_HOLIDAY_CHECK;

	// 萔
	public static final int MODE_UPDATE = 1;

	// p[^
	public static final String PRM_LBL_ATTENDANCE_CALC_Y 		= "lblAttendanceCalcY"	;//ΑӌvZN
	public static final String PRM_LBL_ATTENDANCE_CALC_M 		= "lblAttendanceCalcM"	;//ΑӌvZ
	public static final String PRM_LBL_PAIDHOLIDAY_LY 		= "lblPaidHolidayLY"	;//p\iONj
	public static final String PRM_LBL_PAIDHOLIDAY_TY 		= "lblPaidHolidayTY"	;//p\iNj
	public static final String PRM_LBL_REMAIN_APPROVED 		= "lblRemainApproved"	;//\
	public static final String PRM_LBL_APPROVED 				= "lblApproved"			;//Fς
	public static final String PRM_LBL_THIS_M_GET 			= "lblThisMGet"			;//ǉ\
	public static final String PRM_LBL_THIS_M_DISPOSE 		= "lblThisMDispose"		;//p\
	public static final String PRM_LBL_THIS_M_REST_LY 		= "lblThisMRestLY"		;//p\iONj
	public static final String PRM_LBL_THIS_M_REST_TY 		= "lblThisMRestTY"		;//p\iNj

	// tB[h
	private String lblAttendanceCalcY;
	private String lblAttendanceCalcM;
	private String lblPaidHolidayTY;
	private String lblPaidHolidayLY;
	private String lblRemainApproved;
	private String lblApproved;
	private String lblThisMGet;
	private String lblThisMDispose;
	private String lblThisMRestLY;
	private String lblThisMRestTY;

	// [h(1FXV)
	private int mode;

	// tB[hyѐ
	public static final String NAM_PAYROLL_CALC		= CommonConst.NAM_CONFIRM_PAYMENT + CommonConst.NAM_PROVIDED_YEAR_MONTH;
	public static final String NAM_LAST_M_REST 		= CommonConst.NAM_CUT_OFF_MONTH_THIS + CommonConst.NAM_POSSIBLE_AMOUNT;
	public static final String NAM_THIS_M_GET			= CommonConst.NAM_GET_SCHEDULE;
	public static final String NAM_THIS_M_DISPOSE		= CommonConst.NAM_DISPOSE_SCHEDULE;
	public static final String NAM_THIS_M_REST		= CommonConst.NAM_CUT_OFF_MONTH_AFTER + CommonConst.NAM_POSSIBLE_SCHEDULE;
	public static final String NAM_USE 				= CommonConst.NAM_USE;
	public static final String NAM_REMAIN_APPROVED 	= CommonConst.NAM_APPROVAL_REQUEST;
	public static final String NAM_APPROVED			= CommonConst.NAM_ALREADY_APPROVED + CommonConst.NAM_PAID_HOLIDAY_AMOUNT;
	public static final String NAM_THIS_YEAR 			= CommonConst.NAM_YEAR_THIS;
	public static final String NAM_LAST_YEAR 			= CommonConst.NAM_YEAR_FORMER;

	/**
	 * RXgN^
	 */
	public PaidHolidayCardVo() {
		super();
		mode = 0;
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
	}

	/**
	 * lݒ
	 */	
	public void setDefaultValues(){
		setLblAttendanceCalcY("");
		setLblAttendanceCalcM("");
		setLblPaidHolidayLY("0");
		setLblPaidHolidayTY("0");
		setLblRemainApproved("0");
		setLblApproved("0");
		setLblThisMGet("0");
		setLblThisMDispose("0");
		setLblThisMRestLY("0");
		setLblThisMRestTY("0");
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		lblAttendanceCalcY 	= request.getParameter(PRM_LBL_ATTENDANCE_CALC_Y	); //ΑӌvZN
		lblAttendanceCalcM 	= request.getParameter(PRM_LBL_ATTENDANCE_CALC_M	); //ΑӌvZ
		lblPaidHolidayTY 	= request.getParameter(PRM_LBL_PAIDHOLIDAY_TY		); //p\iNj
		lblPaidHolidayLY 	= request.getParameter(PRM_LBL_PAIDHOLIDAY_LY		); //p\iONj
		lblRemainApproved 	= request.getParameter(PRM_LBL_REMAIN_APPROVED		); //\
		lblApproved 		= request.getParameter(PRM_LBL_APPROVED				); //Fς
		lblThisMGet 		= request.getParameter(PRM_LBL_THIS_M_GET			); //ǉ\
		lblThisMDispose 	= request.getParameter(PRM_LBL_THIS_M_DISPOSE		); //p\
		lblThisMRestLY 		= request.getParameter(PRM_LBL_THIS_M_REST_LY		); //p\iONj
		lblThisMRestTY 		= request.getParameter(PRM_LBL_THIS_M_REST_TY		); //p\iNj
	}

	/**
	 * tB[hݒ
	 * @param dto 
	 */
	public void setFields(MYukyuDto dto) {
		lblPaidHolidayTY 	= String.valueOf(dto.getTZanT());
		lblPaidHolidayLY 	= String.valueOf(dto.getTZanZ());
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh	
	public String getLblAttendanceCalcY		() { return	 lblAttendanceCalcY			; } 	//ΑӌvZN
	public String getLblAttendanceCalcM 	() { return	 lblAttendanceCalcM			; } 	//ΑӌvZ
	public String getLblPaidHolidayTY		() { return	 lblPaidHolidayTY 			; } 	//p\iNj
	public String getLblPaidHolidayLY		() { return	 lblPaidHolidayLY			; } 	//p\iONj
	public String getLblRemainApproved		() { return	 lblRemainApproved			; } 	//\
	public String getLblApproved         	() { return	 lblApproved                ; } 	//F
	public String getLblThisMGet			() { return	 lblThisMGet				; } 	//ǉ\
	public String getLblThisMDispose		() { return	 lblThisMDispose			; } 	//p\
	public String getLblThisMRestTY			() { return	 lblThisMRestTY				; } 	//p\iNj
	public String getLblThisMRestLY			() { return	 lblThisMRestLY				; } 	//p\iONj

	public String getEscLblAttendanceCalcY	() { return	 escapeHTML(lblAttendanceCalcY)	; } 	//ΑӌvZN
	public String getEscLblAttendanceCalcM	() { return	 escapeHTML(lblAttendanceCalcM)	; } 	//ΑӌvZ
	public String getEscLblPaidHolidayTY	() { return	 escapeHTML(lblPaidHolidayTY)	; } 	//p\iNj
	public String getEscLblPaidHolidayLY	() { return	 escapeHTML(lblPaidHolidayLY)	; } 	//p\iONj
	public String getEscLblRemainApproved  	() { return	 escapeHTML(lblRemainApproved)	; } 	//\
	public String getEscLblApproved	    	() { return	 escapeHTML(lblApproved )       ; } 	//F
	public String getEscLblThisMGet			() { return	 escapeHTML(lblThisMGet)		; } 	//ǉ\
	public String getEscLblThisMDispose		() { return	 escapeHTML(lblThisMDispose)	; } 	//p\
	public String getEscLblThisMRestLY		() { return	 escapeHTML(lblThisMRestLY)		; } 	//p\iONj
	public String getEscLblThisMRestTY		() { return	 escapeHTML(lblThisMRestTY)		; } 	//p\iNj

	public void setLblAttendanceCalcY 	(String	lblAttendanceCalcY 	) { this.lblAttendanceCalcY	= lblAttendanceCalcY; } //ΑӌvZN
	public void setLblAttendanceCalcM 	(String	lblAttendanceCalcM 	) { this.lblAttendanceCalcM	= lblAttendanceCalcM; } //ΑӌvZ
	public void setLblPaidHolidayTY	(String	lblPaidHolidayTY   	) { this.lblPaidHolidayTY	= lblPaidHolidayTY	; } //p\iNj
	public void setLblPaidHolidayLY 	(String	lblPaidHolidayLY   	) { this.lblPaidHolidayLY 	= lblPaidHolidayLY	; } //p\iONj
	public void setLblRemainApproved	(String	lblRemainApproved  	) { this.lblRemainApproved 	= lblRemainApproved ; } //\
	public void setLblApproved      	(String lblApproved        	) { this.lblApproved       	= lblApproved      	; } //F
	public void setLblThisMGet	 	 	(String	lblThisMGet			) { this.lblThisMGet	 	= lblThisMGet		; } //ǉ\
	public void setLblThisMDispose	 	(String	lblThisMDispose		) { this.lblThisMDispose	= lblThisMDispose	; } //p\
	public void setLblThisMRestTY	 	(String	lblThisMRestTY		) { this.lblThisMRestTY	 	= lblThisMRestTY	; } //p\iNj
	public void setLblThisMRestLY	 	(String	lblThisMRestLY		) { this.lblThisMRestLY	 	= lblThisMRestLY	; } //p\iONj

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
